<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:param name="xslConvertToCY" select="cif:xslConvertToCY"/>
    <!-- Variable to hold cubic factor -->
    <xsl:variable name="cubicFactor">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">
                <xsl:choose>
                    <xsl:when test="$xslConvertToCY = 1">27</xsl:when>
                    <xsl:otherwise>1</xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- End Area Volume Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis objemu z příčných řezů</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis objemu z příčných řezů</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Cross Section Set Data -->
                            <xsl:for-each select="CrossSectionSet">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en" nowrap="nowrap">Název sady řezů:&#xa0; </th>
                                            <td align="left" colspan="3">
                                                <xsl:value-of select="@setName"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" nowrap="nowrap">Název trasy:&#xa0; </th>
                                            <td align="left" colspan="3">
                                                <xsl:value-of select="@alignmentName"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%" nowrap="nowrap" valign="top">
                                                Koeficient Vstupní rastr: &#xa0;
                                            </th>
                                            <td align="left" style="font-size: 80%" valign="top">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <th align="right" lang="en" style="font-size: 80%" nowrap="nowrap" valign="top">
                                                &#xa0; Poznámka: &#xa0;
                                            </th>
                                            <td align="left" lang="en" style="font-size: 80%">
                                                Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">
                                                    <xsl:choose>
                                                        <xsl:when test="$xslConvertToCY = 1">
                                                            ve stopách, čtverečních stopách a yardech krychlových,
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            ve stopách, čtverečních stopách a stopách krychlových,
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">
                                                    v metrech, metrech čtverečních a metrech krychlových,
                                                </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Volume Data -->
                                <table width="100%">
                                    <xsl:for-each select="CrossSectionStations">
                                        <thead style="display:table-header-group">
                                            <tr>
                                                <th class="underline" lang="en" rowspan="3" valign="bottom">
                                                    Základní trasa<br/>Staničení
                                                </th>
                                                <th colspan="8" lang="en">- - - - - - - - - - - - - - - - Objem staničení - - - - - - - - - - - - - - - -</th>
                                                <th class="underline" lang="en" rowspan="3" valign="bottom">
                                                    <br/>Pořadnice<br/>hmoty
                                                </th>
                                            </tr>
                                            <tr>
                                                <th colspan="4" lang="en">- - - - - - - - - - Zářez - - - - - - - - - -</th>
                                                <th colspan="4" lang="en">- - - - - - - - - - Násyp - - - - - - - - - -</th>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en">Koeficient</th>
                                                <th class="underline" lang="en">Plocha</th>
                                                <th class="underline" lang="en">Objem</th>
                                                <th class="underline" lang="en">Vyrovnání</th>
                                                <th class="underline" lang="en">Koeficient</th>
                                                <th class="underline" lang="en">Plocha</th>
                                                <th class="underline" lang="en">Volume</th>
                                                <th class="underline" lang="en">Vyrovnání</th>
                                            </tr>
                                        </thead>
                                        <xsl:for-each select="CrossSectionStation">
                                            <tbody>
                                                <xsl:apply-templates/>
                                            </tbody>
                                            <tfoot style="display:table-footer-group">
                                                <xsl:if test="position() = last()">
                                                    <xsl:call-template name="grandTotal">
                                                        <xsl:with-param name="allVolumes" select="../*/StationVolume"/>
                                                    </xsl:call-template>
                                                </xsl:if>
                                            </tfoot>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="StationVolume">
        <tr>
            <td align="right" nowrap="nowrap">
                <xsl:value-of select="cif:stationFormat(number(../Station/@externalStation), string(../Station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(CutMaterial/@factor))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:areaFormat(number(CutMaterial/@area))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number(CutMaterial/@volume div $cubicFactor))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number(CutMaterial/@adjustedVolume div $cubicFactor))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(FillMaterial/@factor))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:areaFormat(number(FillMaterial/@area))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number(FillMaterial/@volume div $cubicFactor))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number(FillMaterial/@adjustedVolume div $cubicFactor))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number(@massOrdinate div $cubicFactor))"/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="DerivedStationVolume">
        <tr>
            <td colspan="16">
                <hr size="1px"/>
            </td>
        </tr>
        <tr>
            <td align="right" nowrap="nowrap">
                <xsl:value-of select="cif:stationFormat(number(../Station/@externalStation), string(../Station/@externalStationName))"/>
            </td>
            <td colspan="14">&#xa0;</td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number(@massOrdinate div $cubicFactor))"/>
            </td>
        </tr>
        <tr>
            <td colspan="16" height="50%">
                <hr size="1px"/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template name="grandTotal">
        <xsl:param name="allVolumes"/>
        <tr>
            <td colspan="16">
                <hr/>
            </td>
        </tr>
        <tr>
            <td align="center" colspan="3">Celkový součet:</td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number($allVolumes[position() = last()]/CutMaterial/@cumulativeVolume div $cubicFactor))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number($allVolumes[position() = last()]/CutMaterial/@cumulativeAdjustedVolume div $cubicFactor))"/>
            </td>
            <td colspan="2">&#xa0;</td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number($allVolumes[position() = last()]/FillMaterial/@cumulativeVolume div $cubicFactor))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number($allVolumes[position() = last()]/FillMaterial/@cumulativeAdjustedVolume div $cubicFactor))"/>
            </td>
        </tr>
        <tr>
            <td colspan="16">
                <hr/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Musíte vytvořit příčné řezy podél trasy příčné řezy musí obsahovat povrchy a prvky,
				pro které chcete provést výpis.
            </p>
            <p class="normal1" lang="en">
                XML datový soubor můžete vytvořit v záložce <em>Objemy z příčných řezů</em> ve <em>
                    Vyhodnocení &gt; Příčný řez &gt; Příčné řezy
                </em> příkazem <em> Vytvořit XML výpis </em> v záložce <em>Obecně</em>  nebo ve <em>
                    Vyhodnocení &gt; Příčné řezy &gt; příkazem Výpis příčných řezů </em> se zapnutou volbou <em> Včetně objemu v záložce Hlavní</em> tab.
																		  
								   
														   
													 
								   
													  
            </p>
            <p class="normal1" lang="en">
                Tento výpis není použitelný datové sady obsahující objemy materiálu nebo MDC.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
